#include "..\..\DLL\d_iNES.h"
#include "..\..\Hardware\h_Latch.h"

namespace {
void sync (void) {
	int prgAND = Latch::addr &0x400? 0x07: 0x0F;
	int prgOR  = Latch::addr &0x400? 0x10: 0x00;
	if (Latch::addr &0x080) {
		if (Latch::addr &0x001)
			EMU->SetPRG_ROM32(0x8, (prgOR | Latch::addr >>2 &prgAND) >>1);
		else {
			EMU->SetPRG_ROM16(0x8, prgOR | Latch::addr >>2 &prgAND);
			EMU->SetPRG_ROM16(0xC, prgOR | Latch::addr >>2 &prgAND);
		}
	} else {
		EMU->SetPRG_ROM16(0x8, prgOR | Latch::addr >>2 &prgAND);
		EMU->SetPRG_ROM16(0xC, prgOR);
	}
	if (Latch::addr &0x400)
		EMU->SetCHR_ROM8(0x0, Latch::addr >>6 &~0x03 | Latch::data &0x03);
	else
		EMU->SetCHR_RAM8(0x0, 0);
	if (Latch::addr &0x02)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}

BOOL MAPINT load (void) {
	Latch::load(sync, NULL);
	return TRUE;
}

void MAPINT trapLatchWrite (int bank, int addr, int val) {
	if (~Latch::addr &0x4000) Latch::addr = bank <<12 | addr;
	Latch::data = val;
	sync();
}

void MAPINT reset (RESET_TYPE resetType) {
	Latch::reset(RESET_HARD);
	for (int bank = 0x8; bank <= 0xF; bank++) EMU->SetCPUWriteHandler(bank, trapLatchWrite);
}

uint16_t MapperNum = 599;
} // namespace

MapperInfo MapperInfo_599 = {
	&MapperNum,
	_T("ET-133A"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_AD,
	NULL,
	NULL
};